<?php
 namespace MailPoetVendor; if (!defined('ABSPATH')) exit; class Swift_Signers_OpenDKIMSigner extends \MailPoetVendor\Swift_Signers_DKIMSigner { private $peclLoaded = \false; private $dkimHandler = null; private $dropFirstLF = \true; const CANON_RELAXED = 1; const CANON_SIMPLE = 2; const SIG_RSA_SHA1 = 3; const SIG_RSA_SHA256 = 4; public function __construct($privateKey, $domainName, $selector) { if (!\extension_loaded('opendkim')) { throw new \MailPoetVendor\Swift_SwiftException('php-opendkim extension not found'); } $this->peclLoaded = \true; parent::__construct($privateKey, $domainName, $selector); } public function addSignature(\MailPoetVendor\Swift_Mime_SimpleHeaderSet $headers) { $header = new \MailPoetVendor\Swift_Mime_Headers_OpenDKIMHeader('DKIM-Signature'); $headerVal = $this->dkimHandler->getSignatureHeader(); if (\false === $headerVal || \is_int($headerVal)) { throw new \MailPoetVendor\Swift_SwiftException('OpenDKIM Error: ' . $this->dkimHandler->getError()); } $header->setValue($headerVal); $headers->set($header); return $this; } public function setHeaders(\MailPoetVendor\Swift_Mime_SimpleHeaderSet $headers) { $hash = 'rsa-sha1' == $this->hashAlgorithm ? \MailPoetVendor\OpenDKIMSign::ALG_RSASHA1 : \MailPoetVendor\OpenDKIMSign::ALG_RSASHA256; $bodyCanon = 'simple' == $this->bodyCanon ? \MailPoetVendor\OpenDKIMSign::CANON_SIMPLE : \MailPoetVendor\OpenDKIMSign::CANON_RELAXED; $headerCanon = 'simple' == $this->headerCanon ? \MailPoetVendor\OpenDKIMSign::CANON_SIMPLE : \MailPoetVendor\OpenDKIMSign::CANON_RELAXED; $this->dkimHandler = new \MailPoetVendor\OpenDKIMSign($this->privateKey, $this->selector, $this->domainName, $headerCanon, $bodyCanon, $hash, -1); $this->dkimHandler->setMargin(78); if (!\is_numeric($this->signatureTimestamp)) { \MailPoetVendor\OpenDKIM::setOption(\MailPoetVendor\OpenDKIM::OPTS_FIXEDTIME, \time()); } else { if (!\MailPoetVendor\OpenDKIM::setOption(\MailPoetVendor\OpenDKIM::OPTS_FIXEDTIME, $this->signatureTimestamp)) { throw new \MailPoetVendor\Swift_SwiftException('Unable to force signature timestamp [' . \openssl_error_string() . ']'); } } if (isset($this->signerIdentity)) { $this->dkimHandler->setSigner($this->signerIdentity); } $listHeaders = $headers->listAll(); foreach ($listHeaders as $hName) { if (!isset($this->ignoredHeaders[\strtolower($hName)])) { $tmp = $headers->getAll($hName); if ($headers->has($hName)) { foreach ($tmp as $header) { if ('' != $header->getFieldBody()) { $htosign = $header->toString(); $this->dkimHandler->header($htosign); $this->signedHeaders[] = $header->getFieldName(); } } } } } return $this; } public function startBody() { if (!$this->peclLoaded) { return parent::startBody(); } $this->dropFirstLF = \true; $this->dkimHandler->eoh(); return $this; } public function endBody() { if (!$this->peclLoaded) { return parent::endBody(); } $this->dkimHandler->eom(); return $this; } public function reset() { $this->dkimHandler = null; parent::reset(); return $this; } public function setSignatureTimestamp($time) { $this->signatureTimestamp = $time; return $this; } public function setSignatureExpiration($time) { $this->signatureExpiration = $time; return $this; } public function setDebugHeaders($debug) { $this->debugHeaders = (bool) $debug; return $this; } protected function canonicalizeBody($string) { if (!$this->peclLoaded) { return parent::canonicalizeBody($string); } if (\true === $this->dropFirstLF) { if ("\r" == $string[0] && "\n" == $string[1]) { $string = \substr($string, 2); } } $this->dropFirstLF = \false; if (\strlen($string)) { $this->dkimHandler->body($string); } } } 