<?php
 namespace MailPoetVendor\Doctrine\Persistence\Mapping; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\Common\Cache\Cache; use MailPoetVendor\Doctrine\Persistence\Mapping\Driver\MappingDriver; use MailPoetVendor\Doctrine\Persistence\Proxy; use ReflectionException; use function array_reverse; use function array_unshift; use function explode; use function strpos; use function strrpos; use function substr; abstract class AbstractClassMetadataFactory implements \MailPoetVendor\Doctrine\Persistence\Mapping\ClassMetadataFactory { protected $cacheSalt = '$CLASSMETADATA'; private $cacheDriver; private $loadedMetadata = []; protected $initialized = \false; private $reflectionService = null; public function setCacheDriver(?\MailPoetVendor\Doctrine\Common\Cache\Cache $cacheDriver = null) { $this->cacheDriver = $cacheDriver; } public function getCacheDriver() { return $this->cacheDriver; } public function getLoadedMetadata() { return $this->loadedMetadata; } public function getAllMetadata() { if (!$this->initialized) { $this->initialize(); } $driver = $this->getDriver(); $metadata = []; foreach ($driver->getAllClassNames() as $className) { $metadata[] = $this->getMetadataFor($className); } return $metadata; } protected abstract function initialize(); protected abstract function getFqcnFromAlias($namespaceAlias, $simpleClassName); protected abstract function getDriver(); protected abstract function wakeupReflection(\MailPoetVendor\Doctrine\Persistence\Mapping\ClassMetadata $class, \MailPoetVendor\Doctrine\Persistence\Mapping\ReflectionService $reflService); protected abstract function initializeReflection(\MailPoetVendor\Doctrine\Persistence\Mapping\ClassMetadata $class, \MailPoetVendor\Doctrine\Persistence\Mapping\ReflectionService $reflService); protected abstract function isEntity(\MailPoetVendor\Doctrine\Persistence\Mapping\ClassMetadata $class); public function getMetadataFor($className) { if (isset($this->loadedMetadata[$className])) { return $this->loadedMetadata[$className]; } if (\strpos($className, ':') !== \false) { [$namespaceAlias, $simpleClassName] = \explode(':', $className, 2); $realClassName = $this->getFqcnFromAlias($namespaceAlias, $simpleClassName); } else { $realClassName = $this->getRealClass($className); } if (isset($this->loadedMetadata[$realClassName])) { return $this->loadedMetadata[$className] = $this->loadedMetadata[$realClassName]; } $loadingException = null; try { if ($this->cacheDriver) { $cached = $this->cacheDriver->fetch($realClassName . $this->cacheSalt); if ($cached instanceof \MailPoetVendor\Doctrine\Persistence\Mapping\ClassMetadata) { $this->loadedMetadata[$realClassName] = $cached; $this->wakeupReflection($cached, $this->getReflectionService()); } else { foreach ($this->loadMetadata($realClassName) as $loadedClassName) { $this->cacheDriver->save($loadedClassName . $this->cacheSalt, $this->loadedMetadata[$loadedClassName]); } } } else { $this->loadMetadata($realClassName); } } catch (\MailPoetVendor\Doctrine\Persistence\Mapping\MappingException $loadingException) { $fallbackMetadataResponse = $this->onNotFoundMetadata($realClassName); if (!$fallbackMetadataResponse) { throw $loadingException; } $this->loadedMetadata[$realClassName] = $fallbackMetadataResponse; } if ($className !== $realClassName) { $this->loadedMetadata[$className] = $this->loadedMetadata[$realClassName]; } return $this->loadedMetadata[$className]; } public function hasMetadataFor($className) { return isset($this->loadedMetadata[$className]); } public function setMetadataFor($className, $class) { $this->loadedMetadata[$className] = $class; } protected function getParentClasses($name) { $parentClasses = []; foreach (\array_reverse($this->getReflectionService()->getParentClasses($name)) as $parentClass) { if ($this->getDriver()->isTransient($parentClass)) { continue; } $parentClasses[] = $parentClass; } return $parentClasses; } protected function loadMetadata($name) { if (!$this->initialized) { $this->initialize(); } $loaded = []; $parentClasses = $this->getParentClasses($name); $parentClasses[] = $name; $parent = null; $rootEntityFound = \false; $visited = []; $reflService = $this->getReflectionService(); foreach ($parentClasses as $className) { if (isset($this->loadedMetadata[$className])) { $parent = $this->loadedMetadata[$className]; if ($this->isEntity($parent)) { $rootEntityFound = \true; \array_unshift($visited, $className); } continue; } $class = $this->newClassMetadataInstance($className); $this->initializeReflection($class, $reflService); $this->doLoadMetadata($class, $parent, $rootEntityFound, $visited); $this->loadedMetadata[$className] = $class; $parent = $class; if ($this->isEntity($class)) { $rootEntityFound = \true; \array_unshift($visited, $className); } $this->wakeupReflection($class, $reflService); $loaded[] = $className; } return $loaded; } protected function onNotFoundMetadata($className) { return null; } protected abstract function doLoadMetadata($class, $parent, $rootEntityFound, array $nonSuperclassParents); protected abstract function newClassMetadataInstance($className); public function isTransient($class) { if (!$this->initialized) { $this->initialize(); } if (\strpos($class, ':') !== \false) { [$namespaceAlias, $simpleClassName] = \explode(':', $class, 2); $class = $this->getFqcnFromAlias($namespaceAlias, $simpleClassName); } return $this->getDriver()->isTransient($class); } public function setReflectionService(\MailPoetVendor\Doctrine\Persistence\Mapping\ReflectionService $reflectionService) { $this->reflectionService = $reflectionService; } public function getReflectionService() { if ($this->reflectionService === null) { $this->reflectionService = new \MailPoetVendor\Doctrine\Persistence\Mapping\RuntimeReflectionService(); } return $this->reflectionService; } private function getRealClass(string $class) : string { $pos = \strrpos($class, '\\' . \MailPoetVendor\Doctrine\Persistence\Proxy::MARKER . '\\'); if ($pos === \false) { return $class; } return \substr($class, $pos + \MailPoetVendor\Doctrine\Persistence\Proxy::MARKER_LENGTH + 2); } } 