<?php
 namespace MailPoetVendor\Doctrine\ORM\Tools\Pagination; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\ORM\NoResultException; use MailPoetVendor\Doctrine\ORM\Query; use MailPoetVendor\Doctrine\ORM\Query\Parser; use MailPoetVendor\Doctrine\ORM\Query\ResultSetMapping; use MailPoetVendor\Doctrine\ORM\QueryBuilder; use function array_map; use function array_sum; class Paginator implements \Countable, \IteratorAggregate { private $query; private $fetchJoinCollection; private $useOutputWalkers; private $count; public function __construct($query, $fetchJoinCollection = \true) { if ($query instanceof \MailPoetVendor\Doctrine\ORM\QueryBuilder) { $query = $query->getQuery(); } $this->query = $query; $this->fetchJoinCollection = (bool) $fetchJoinCollection; } public function getQuery() { return $this->query; } public function getFetchJoinCollection() { return $this->fetchJoinCollection; } public function getUseOutputWalkers() { return $this->useOutputWalkers; } public function setUseOutputWalkers($useOutputWalkers) { $this->useOutputWalkers = $useOutputWalkers; return $this; } public function count() { if ($this->count === null) { try { $this->count = (int) \array_sum(\array_map('current', $this->getCountQuery()->getScalarResult())); } catch (\MailPoetVendor\Doctrine\ORM\NoResultException $e) { $this->count = 0; } } return $this->count; } public function getIterator() { $offset = $this->query->getFirstResult(); $length = $this->query->getMaxResults(); if ($this->fetchJoinCollection && $length !== null) { $subQuery = $this->cloneQuery($this->query); if ($this->useOutputWalker($subQuery)) { $subQuery->setHint(\MailPoetVendor\Doctrine\ORM\Query::HINT_CUSTOM_OUTPUT_WALKER, \MailPoetVendor\Doctrine\ORM\Tools\Pagination\LimitSubqueryOutputWalker::class); } else { $this->appendTreeWalker($subQuery, \MailPoetVendor\Doctrine\ORM\Tools\Pagination\LimitSubqueryWalker::class); $this->unbindUnusedQueryParams($subQuery); } $subQuery->setFirstResult($offset)->setMaxResults($length); $foundIdRows = $subQuery->getScalarResult(); if ($foundIdRows === []) { return new \ArrayIterator([]); } $whereInQuery = $this->cloneQuery($this->query); $ids = \array_map('current', $foundIdRows); $this->appendTreeWalker($whereInQuery, \MailPoetVendor\Doctrine\ORM\Tools\Pagination\WhereInWalker::class); $whereInQuery->setHint(\MailPoetVendor\Doctrine\ORM\Tools\Pagination\WhereInWalker::HINT_PAGINATOR_ID_COUNT, \count($ids)); $whereInQuery->setFirstResult(null)->setMaxResults(null); $whereInQuery->setParameter(\MailPoetVendor\Doctrine\ORM\Tools\Pagination\WhereInWalker::PAGINATOR_ID_ALIAS, $ids); $whereInQuery->setCacheable($this->query->isCacheable()); $whereInQuery->expireQueryCache(); $result = $whereInQuery->getResult($this->query->getHydrationMode()); } else { $result = $this->cloneQuery($this->query)->setMaxResults($length)->setFirstResult($offset)->setCacheable($this->query->isCacheable())->getResult($this->query->getHydrationMode()); } return new \ArrayIterator($result); } private function cloneQuery(\MailPoetVendor\Doctrine\ORM\Query $query) { $cloneQuery = clone $query; $cloneQuery->setParameters(clone $query->getParameters()); $cloneQuery->setCacheable(\false); foreach ($query->getHints() as $name => $value) { $cloneQuery->setHint($name, $value); } return $cloneQuery; } private function useOutputWalker(\MailPoetVendor\Doctrine\ORM\Query $query) { if ($this->useOutputWalkers === null) { return (bool) $query->getHint(\MailPoetVendor\Doctrine\ORM\Query::HINT_CUSTOM_OUTPUT_WALKER) === \false; } return $this->useOutputWalkers; } private function appendTreeWalker(\MailPoetVendor\Doctrine\ORM\Query $query, $walkerClass) { $hints = $query->getHint(\MailPoetVendor\Doctrine\ORM\Query::HINT_CUSTOM_TREE_WALKERS); if ($hints === \false) { $hints = []; } $hints[] = $walkerClass; $query->setHint(\MailPoetVendor\Doctrine\ORM\Query::HINT_CUSTOM_TREE_WALKERS, $hints); } private function getCountQuery() { $countQuery = $this->cloneQuery($this->query); if (!$countQuery->hasHint(\MailPoetVendor\Doctrine\ORM\Tools\Pagination\CountWalker::HINT_DISTINCT)) { $countQuery->setHint(\MailPoetVendor\Doctrine\ORM\Tools\Pagination\CountWalker::HINT_DISTINCT, \true); } if ($this->useOutputWalker($countQuery)) { $platform = $countQuery->getEntityManager()->getConnection()->getDatabasePlatform(); $rsm = new \MailPoetVendor\Doctrine\ORM\Query\ResultSetMapping(); $rsm->addScalarResult($platform->getSQLResultCasing('dctrn_count'), 'count'); $countQuery->setHint(\MailPoetVendor\Doctrine\ORM\Query::HINT_CUSTOM_OUTPUT_WALKER, \MailPoetVendor\Doctrine\ORM\Tools\Pagination\CountOutputWalker::class); $countQuery->setResultSetMapping($rsm); } else { $this->appendTreeWalker($countQuery, \MailPoetVendor\Doctrine\ORM\Tools\Pagination\CountWalker::class); $this->unbindUnusedQueryParams($countQuery); } $countQuery->setFirstResult(null)->setMaxResults(null); return $countQuery; } private function unbindUnusedQueryParams(\MailPoetVendor\Doctrine\ORM\Query $query) : void { $parser = new \MailPoetVendor\Doctrine\ORM\Query\Parser($query); $parameterMappings = $parser->parse()->getParameterMappings(); $parameters = $query->getParameters(); foreach ($parameters as $key => $parameter) { $parameterName = $parameter->getName(); if (!(isset($parameterMappings[$parameterName]) || \array_key_exists($parameterName, $parameterMappings))) { unset($parameters[$key]); } } $query->setParameters($parameters); } } 