<?php
 namespace MailPoetVendor\Doctrine\DBAL\Driver; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\DBAL\FetchMode; use MailPoetVendor\Doctrine\DBAL\ParameterType; use PDO; use const E_USER_DEPRECATED; use function sprintf; use function trigger_error; class PDOStatement extends \PDOStatement implements \MailPoetVendor\Doctrine\DBAL\Driver\Statement { private const PARAM_TYPE_MAP = [\MailPoetVendor\Doctrine\DBAL\ParameterType::NULL => \PDO::PARAM_NULL, \MailPoetVendor\Doctrine\DBAL\ParameterType::INTEGER => \PDO::PARAM_INT, \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING => \PDO::PARAM_STR, \MailPoetVendor\Doctrine\DBAL\ParameterType::BINARY => \PDO::PARAM_LOB, \MailPoetVendor\Doctrine\DBAL\ParameterType::LARGE_OBJECT => \PDO::PARAM_LOB, \MailPoetVendor\Doctrine\DBAL\ParameterType::BOOLEAN => \PDO::PARAM_BOOL]; private const FETCH_MODE_MAP = [\MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE => \PDO::FETCH_ASSOC, \MailPoetVendor\Doctrine\DBAL\FetchMode::NUMERIC => \PDO::FETCH_NUM, \MailPoetVendor\Doctrine\DBAL\FetchMode::MIXED => \PDO::FETCH_BOTH, \MailPoetVendor\Doctrine\DBAL\FetchMode::STANDARD_OBJECT => \PDO::FETCH_OBJ, \MailPoetVendor\Doctrine\DBAL\FetchMode::COLUMN => \PDO::FETCH_COLUMN, \MailPoetVendor\Doctrine\DBAL\FetchMode::CUSTOM_OBJECT => \PDO::FETCH_CLASS]; protected function __construct() { } public function setFetchMode($fetchMode, $arg2 = null, $arg3 = null) { $fetchMode = $this->convertFetchMode($fetchMode); try { if ($arg2 === null && $arg3 === null) { return parent::setFetchMode($fetchMode); } if ($arg3 === null) { return parent::setFetchMode($fetchMode, $arg2); } return parent::setFetchMode($fetchMode, $arg2, $arg3); } catch (\PDOException $exception) { throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception); } } public function bindValue($param, $value, $type = \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING) { $type = $this->convertParamType($type); try { return parent::bindValue($param, $value, $type); } catch (\PDOException $exception) { throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception); } } public function bindParam($column, &$variable, $type = \MailPoetVendor\Doctrine\DBAL\ParameterType::STRING, $length = null, $driverOptions = null) { $type = $this->convertParamType($type); try { return parent::bindParam($column, $variable, $type, $length, $driverOptions); } catch (\PDOException $exception) { throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception); } } public function closeCursor() { try { return parent::closeCursor(); } catch (\PDOException $exception) { return \true; } } public function execute($params = null) { try { return parent::execute($params); } catch (\PDOException $exception) { throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception); } } public function fetch($fetchMode = null, $cursorOrientation = \PDO::FETCH_ORI_NEXT, $cursorOffset = 0) { $fetchMode = $this->convertFetchMode($fetchMode); try { if ($fetchMode === null && $cursorOrientation === \PDO::FETCH_ORI_NEXT && $cursorOffset === 0) { return parent::fetch(); } if ($cursorOrientation === \PDO::FETCH_ORI_NEXT && $cursorOffset === 0) { return parent::fetch($fetchMode); } if ($cursorOffset === 0) { return parent::fetch($fetchMode, $cursorOrientation); } return parent::fetch($fetchMode, $cursorOrientation, $cursorOffset); } catch (\PDOException $exception) { throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception); } } public function fetchAll($fetchMode = null, $fetchArgument = null, $ctorArgs = null) { $fetchMode = $this->convertFetchMode($fetchMode); try { if ($fetchMode === null && $fetchArgument === null && $ctorArgs === null) { return parent::fetchAll(); } if ($fetchArgument === null && $ctorArgs === null) { return parent::fetchAll($fetchMode); } if ($ctorArgs === null) { return parent::fetchAll($fetchMode, $fetchArgument); } return parent::fetchAll($fetchMode, $fetchArgument, $ctorArgs); } catch (\PDOException $exception) { throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception); } } public function fetchColumn($columnIndex = 0) { try { return parent::fetchColumn($columnIndex); } catch (\PDOException $exception) { throw new \MailPoetVendor\Doctrine\DBAL\Driver\PDOException($exception); } } private function convertParamType(int $type) : int { if (!isset(self::PARAM_TYPE_MAP[$type])) { @\trigger_error(\sprintf('Using a PDO parameter type (%d given) is deprecated and will cause an error in Doctrine 3.0', $type), \E_USER_DEPRECATED); return $type; } return self::PARAM_TYPE_MAP[$type]; } private function convertFetchMode(?int $fetchMode) : ?int { if ($fetchMode === null) { return null; } if (!isset(self::FETCH_MODE_MAP[$fetchMode])) { @\trigger_error(\sprintf('Using a PDO fetch mode or their combination (%d given)' . ' is deprecated and will cause an error in Doctrine 3.0', $fetchMode), \E_USER_DEPRECATED); return $fetchMode; } return self::FETCH_MODE_MAP[$fetchMode]; } } 