<?php
 namespace MailPoetVendor\Doctrine\DBAL\Cache; if (!defined('ABSPATH')) exit; use ArrayIterator; use MailPoetVendor\Doctrine\Common\Cache\Cache; use MailPoetVendor\Doctrine\DBAL\Driver\ResultStatement; use MailPoetVendor\Doctrine\DBAL\Driver\Statement; use MailPoetVendor\Doctrine\DBAL\FetchMode; use InvalidArgumentException; use IteratorAggregate; use PDO; use function array_merge; use function array_values; use function reset; class ResultCacheStatement implements \IteratorAggregate, \MailPoetVendor\Doctrine\DBAL\Driver\ResultStatement { private $resultCache; private $cacheKey; private $realKey; private $lifetime; private $statement; private $emptied = \false; private $data; private $defaultFetchMode = \MailPoetVendor\Doctrine\DBAL\FetchMode::MIXED; public function __construct(\MailPoetVendor\Doctrine\DBAL\Driver\Statement $stmt, \MailPoetVendor\Doctrine\Common\Cache\Cache $resultCache, $cacheKey, $realKey, $lifetime) { $this->statement = $stmt; $this->resultCache = $resultCache; $this->cacheKey = $cacheKey; $this->realKey = $realKey; $this->lifetime = $lifetime; } public function closeCursor() { $this->statement->closeCursor(); if (!$this->emptied || $this->data === null) { return \true; } $data = $this->resultCache->fetch($this->cacheKey); if (!$data) { $data = []; } $data[$this->realKey] = $this->data; $this->resultCache->save($this->cacheKey, $data, $this->lifetime); unset($this->data); return \true; } public function columnCount() { return $this->statement->columnCount(); } public function setFetchMode($fetchMode, $arg2 = null, $arg3 = null) { $this->defaultFetchMode = $fetchMode; return \true; } public function getIterator() { $data = $this->fetchAll(); return new \ArrayIterator($data); } public function fetch($fetchMode = null, $cursorOrientation = \PDO::FETCH_ORI_NEXT, $cursorOffset = 0) { if ($this->data === null) { $this->data = []; } $row = $this->statement->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE); if ($row) { $this->data[] = $row; $fetchMode = $fetchMode ?: $this->defaultFetchMode; if ($fetchMode === \MailPoetVendor\Doctrine\DBAL\FetchMode::ASSOCIATIVE) { return $row; } if ($fetchMode === \MailPoetVendor\Doctrine\DBAL\FetchMode::NUMERIC) { return \array_values($row); } if ($fetchMode === \MailPoetVendor\Doctrine\DBAL\FetchMode::MIXED) { return \array_merge($row, \array_values($row)); } if ($fetchMode === \MailPoetVendor\Doctrine\DBAL\FetchMode::COLUMN) { return \reset($row); } throw new \InvalidArgumentException('Invalid fetch-style given for caching result.'); } $this->emptied = \true; return \false; } public function fetchAll($fetchMode = null, $fetchArgument = null, $ctorArgs = null) { $data = $this->statement->fetchAll($fetchMode, $fetchArgument, $ctorArgs); if ($fetchMode === \MailPoetVendor\Doctrine\DBAL\FetchMode::COLUMN) { foreach ($data as $key => $value) { $data[$key] = [$value]; } } $this->data = $data; $this->emptied = \true; return $this->data; } public function fetchColumn($columnIndex = 0) { $row = $this->fetch(\MailPoetVendor\Doctrine\DBAL\FetchMode::NUMERIC); return $row[$columnIndex] ?? \false; } public function rowCount() { return $this->statement->rowCount(); } } 