<?php
 namespace MailPoetVendor\Doctrine\ORM\Persisters\Entity; if (!defined('ABSPATH')) exit; use MailPoetVendor\Doctrine\Common\Collections\Criteria; use MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison; use MailPoetVendor\Doctrine\Common\Util\ClassUtils; use MailPoetVendor\Doctrine\DBAL\Connection; use MailPoetVendor\Doctrine\DBAL\LockMode; use MailPoetVendor\Doctrine\DBAL\Types\Type; use MailPoetVendor\Doctrine\ORM\EntityManagerInterface; use MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata; use MailPoetVendor\Doctrine\ORM\Mapping\MappingException; use MailPoetVendor\Doctrine\ORM\OptimisticLockException; use MailPoetVendor\Doctrine\ORM\ORMException; use MailPoetVendor\Doctrine\ORM\PersistentCollection; use MailPoetVendor\Doctrine\ORM\Persisters\SqlExpressionVisitor; use MailPoetVendor\Doctrine\ORM\Persisters\SqlValueVisitor; use MailPoetVendor\Doctrine\ORM\Query; use MailPoetVendor\Doctrine\ORM\UnitOfWork; use MailPoetVendor\Doctrine\ORM\Utility\IdentifierFlattener; use MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper; use function array_key_exists; use function array_map; use function array_merge; use function assert; use function reset; class BasicEntityPersister implements \MailPoetVendor\Doctrine\ORM\Persisters\Entity\EntityPersister { private static $comparisonMap = [\MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::EQ => '= %s', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::NEQ => '!= %s', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::GT => '> %s', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::GTE => '>= %s', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::LT => '< %s', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::LTE => '<= %s', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::IN => 'IN (%s)', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::NIN => 'NOT IN (%s)', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::CONTAINS => 'LIKE %s', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::STARTS_WITH => 'LIKE %s', \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::ENDS_WITH => 'LIKE %s']; protected $class; protected $conn; protected $platform; protected $em; protected $queuedInserts = []; protected $columnTypes = []; protected $quotedColumns = []; private $insertSql; protected $quoteStrategy; private $identifierFlattener; protected $currentPersisterContext; private $limitsHandlingContext; private $noLimitsContext; public function __construct(\MailPoetVendor\Doctrine\ORM\EntityManagerInterface $em, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class) { $this->em = $em; $this->class = $class; $this->conn = $em->getConnection(); $this->platform = $this->conn->getDatabasePlatform(); $this->quoteStrategy = $em->getConfiguration()->getQuoteStrategy(); $this->identifierFlattener = new \MailPoetVendor\Doctrine\ORM\Utility\IdentifierFlattener($em->getUnitOfWork(), $em->getMetadataFactory()); $this->noLimitsContext = $this->currentPersisterContext = new \MailPoetVendor\Doctrine\ORM\Persisters\Entity\CachedPersisterContext($class, new \MailPoetVendor\Doctrine\ORM\Query\ResultSetMapping(), \false); $this->limitsHandlingContext = new \MailPoetVendor\Doctrine\ORM\Persisters\Entity\CachedPersisterContext($class, new \MailPoetVendor\Doctrine\ORM\Query\ResultSetMapping(), \true); } public function getClassMetadata() { return $this->class; } public function getResultSetMapping() { return $this->currentPersisterContext->rsm; } public function addInsert($entity) { $this->queuedInserts[\spl_object_hash($entity)] = $entity; } public function getInserts() { return $this->queuedInserts; } public function executeInserts() { if (!$this->queuedInserts) { return []; } $postInsertIds = []; $idGenerator = $this->class->idGenerator; $isPostInsertId = $idGenerator->isPostInsertGenerator(); $stmt = $this->conn->prepare($this->getInsertSQL()); $tableName = $this->class->getTableName(); foreach ($this->queuedInserts as $entity) { $insertData = $this->prepareInsertData($entity); if (isset($insertData[$tableName])) { $paramIndex = 1; foreach ($insertData[$tableName] as $column => $value) { $stmt->bindValue($paramIndex++, $value, $this->columnTypes[$column]); } } $stmt->execute(); if ($isPostInsertId) { $generatedId = $idGenerator->generate($this->em, $entity); $id = [$this->class->identifier[0] => $generatedId]; $postInsertIds[] = ['generatedId' => $generatedId, 'entity' => $entity]; } else { $id = $this->class->getIdentifierValues($entity); } if ($this->class->isVersioned) { $this->assignDefaultVersionValue($entity, $id); } } $stmt->closeCursor(); $this->queuedInserts = []; return $postInsertIds; } protected function assignDefaultVersionValue($entity, array $id) { $value = $this->fetchVersionValue($this->class, $id); $this->class->setFieldValue($entity, $this->class->versionField, $value); } protected function fetchVersionValue($versionedClass, array $id) { $versionField = $versionedClass->versionField; $fieldMapping = $versionedClass->fieldMappings[$versionField]; $tableName = $this->quoteStrategy->getTableName($versionedClass, $this->platform); $identifier = $this->quoteStrategy->getIdentifierColumnNames($versionedClass, $this->platform); $columnName = $this->quoteStrategy->getColumnName($versionField, $versionedClass, $this->platform); $sql = 'SELECT ' . $columnName . ' FROM ' . $tableName . ' WHERE ' . \implode(' = ? AND ', $identifier) . ' = ?'; $flatId = $this->identifierFlattener->flattenIdentifier($versionedClass, $id); $value = $this->conn->fetchColumn($sql, \array_values($flatId), 0, $this->extractIdentifierTypes($id, $versionedClass)); return \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($fieldMapping['type'])->convertToPHPValue($value, $this->platform); } private function extractIdentifierTypes(array $id, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $versionedClass) : array { $types = []; foreach ($id as $field => $value) { $types = \array_merge($types, $this->getTypes($field, $value, $versionedClass)); } return $types; } public function update($entity) { $tableName = $this->class->getTableName(); $updateData = $this->prepareUpdateData($entity); if (!isset($updateData[$tableName]) || !($data = $updateData[$tableName])) { return; } $isVersioned = $this->class->isVersioned; $quotedTableName = $this->quoteStrategy->getTableName($this->class, $this->platform); $this->updateTable($entity, $quotedTableName, $data, $isVersioned); if ($isVersioned) { $id = $this->em->getUnitOfWork()->getEntityIdentifier($entity); $this->assignDefaultVersionValue($entity, $id); } } protected final function updateTable($entity, $quotedTableName, array $updateData, $versioned = \false) { $set = []; $types = []; $params = []; foreach ($updateData as $columnName => $value) { $placeholder = '?'; $column = $columnName; switch (\true) { case isset($this->class->fieldNames[$columnName]): $fieldName = $this->class->fieldNames[$columnName]; $column = $this->quoteStrategy->getColumnName($fieldName, $this->class, $this->platform); if (isset($this->class->fieldMappings[$fieldName]['requireSQLConversion'])) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($this->columnTypes[$columnName]); $placeholder = $type->convertToDatabaseValueSQL('?', $this->platform); } break; case isset($this->quotedColumns[$columnName]): $column = $this->quotedColumns[$columnName]; break; } $params[] = $value; $set[] = $column . ' = ' . $placeholder; $types[] = $this->columnTypes[$columnName]; } $where = []; $identifier = $this->em->getUnitOfWork()->getEntityIdentifier($entity); $quotedClassTableName = $this->quoteStrategy->getTableName($this->class, $this->platform); foreach ($this->class->identifier as $idField) { if (!isset($this->class->associationMappings[$idField])) { $params[] = $identifier[$idField]; $types[] = $this->class->fieldMappings[$idField]['type']; $class = $this->class; if (isset($class->fieldMappings[$idField]['inherited']) && $quotedTableName !== $quotedClassTableName) { $className = $this->class->fieldMappings[$idField]['inherited']; $class = $this->em->getClassMetadata($className); } $where[] = $this->quoteStrategy->getColumnName($idField, $class, $this->platform); continue; } $params[] = $identifier[$idField]; $where[] = $this->quoteStrategy->getJoinColumnName($this->class->associationMappings[$idField]['joinColumns'][0], $this->class, $this->platform); $targetMapping = $this->em->getClassMetadata($this->class->associationMappings[$idField]['targetEntity']); $targetType = \MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper::getTypeOfField($targetMapping->identifier[0], $targetMapping, $this->em); if ($targetType === []) { throw \MailPoetVendor\Doctrine\ORM\ORMException::unrecognizedField($targetMapping->identifier[0]); } $types[] = \reset($targetType); } if ($versioned) { $versionField = $this->class->versionField; $versionFieldType = $this->class->fieldMappings[$versionField]['type']; $versionColumn = $this->quoteStrategy->getColumnName($versionField, $this->class, $this->platform); $where[] = $versionColumn; $types[] = $this->class->fieldMappings[$versionField]['type']; $params[] = $this->class->reflFields[$versionField]->getValue($entity); switch ($versionFieldType) { case \MailPoetVendor\Doctrine\DBAL\Types\Type::SMALLINT: case \MailPoetVendor\Doctrine\DBAL\Types\Type::INTEGER: case \MailPoetVendor\Doctrine\DBAL\Types\Type::BIGINT: $set[] = $versionColumn . ' = ' . $versionColumn . ' + 1'; break; case \MailPoetVendor\Doctrine\DBAL\Types\Type::DATETIME: $set[] = $versionColumn . ' = CURRENT_TIMESTAMP'; break; } } $sql = 'UPDATE ' . $quotedTableName . ' SET ' . \implode(', ', $set) . ' WHERE ' . \implode(' = ? AND ', $where) . ' = ?'; $result = $this->conn->executeUpdate($sql, $params, $types); if ($versioned && !$result) { throw \MailPoetVendor\Doctrine\ORM\OptimisticLockException::lockFailed($entity); } } protected function deleteJoinTableRecords($identifier) { foreach ($this->class->associationMappings as $mapping) { if ($mapping['type'] !== \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::MANY_TO_MANY) { continue; } $selfReferential = $mapping['targetEntity'] == $mapping['sourceEntity']; $class = $this->class; $association = $mapping; $otherColumns = []; $otherKeys = []; $keys = []; if (!$mapping['isOwningSide']) { $class = $this->em->getClassMetadata($mapping['targetEntity']); $association = $class->associationMappings[$mapping['mappedBy']]; } $joinColumns = $mapping['isOwningSide'] ? $association['joinTable']['joinColumns'] : $association['joinTable']['inverseJoinColumns']; if ($selfReferential) { $otherColumns = !$mapping['isOwningSide'] ? $association['joinTable']['joinColumns'] : $association['joinTable']['inverseJoinColumns']; } foreach ($joinColumns as $joinColumn) { $keys[] = $this->quoteStrategy->getJoinColumnName($joinColumn, $class, $this->platform); } foreach ($otherColumns as $joinColumn) { $otherKeys[] = $this->quoteStrategy->getJoinColumnName($joinColumn, $class, $this->platform); } if (isset($mapping['isOnDeleteCascade'])) { continue; } $joinTableName = $this->quoteStrategy->getJoinTableName($association, $this->class, $this->platform); $this->conn->delete($joinTableName, \array_combine($keys, $identifier)); if ($selfReferential) { $this->conn->delete($joinTableName, \array_combine($otherKeys, $identifier)); } } } public function delete($entity) { $class = $this->class; $identifier = $this->em->getUnitOfWork()->getEntityIdentifier($entity); $tableName = $this->quoteStrategy->getTableName($class, $this->platform); $idColumns = $this->quoteStrategy->getIdentifierColumnNames($class, $this->platform); $id = \array_combine($idColumns, $identifier); $types = $this->getClassIdentifiersTypes($class); $this->deleteJoinTableRecords($identifier); return (bool) $this->conn->delete($tableName, $id, $types); } protected function prepareUpdateData($entity) { $versionField = null; $result = []; $uow = $this->em->getUnitOfWork(); if (($versioned = $this->class->isVersioned) != \false) { $versionField = $this->class->versionField; } foreach ($uow->getEntityChangeSet($entity) as $field => $change) { if (isset($versionField) && $versionField == $field) { continue; } if (isset($this->class->embeddedClasses[$field])) { continue; } $newVal = $change[1]; if (!isset($this->class->associationMappings[$field])) { $class = $this->class; foreach ($class->parentClasses as $parentClassName) { $parentClass = $this->em->getClassMetadata($parentClassName); if (\array_key_exists($field, $parentClass->fieldMappings)) { $class = $parentClass; } } $fieldMapping = $class->fieldMappings[$field]; $columnName = $fieldMapping['columnName']; $this->columnTypes[$columnName] = $fieldMapping['type']; $result[$this->getOwningTable($field)][$columnName] = $newVal; continue; } $assoc = $this->class->associationMappings[$field]; if (!$assoc['isOwningSide'] || !($assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE)) { continue; } if ($newVal !== null) { $oid = \spl_object_hash($newVal); if (isset($this->queuedInserts[$oid]) || $uow->isScheduledForInsert($newVal)) { $uow->scheduleExtraUpdate($entity, [$field => [null, $newVal]]); $newVal = null; } } $newValId = null; if ($newVal !== null) { $newValId = $uow->getEntityIdentifier($newVal); } $targetClass = $this->em->getClassMetadata($assoc['targetEntity']); $owningTable = $this->getOwningTable($field); foreach ($assoc['joinColumns'] as $joinColumn) { $sourceColumn = $joinColumn['name']; $targetColumn = $joinColumn['referencedColumnName']; $quotedColumn = $this->quoteStrategy->getJoinColumnName($joinColumn, $this->class, $this->platform); $this->quotedColumns[$sourceColumn] = $quotedColumn; $this->columnTypes[$sourceColumn] = \MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper::getTypeOfColumn($targetColumn, $targetClass, $this->em); $result[$owningTable][$sourceColumn] = $newValId ? $newValId[$targetClass->getFieldForColumn($targetColumn)] : null; } } return $result; } protected function prepareInsertData($entity) { return $this->prepareUpdateData($entity); } public function getOwningTable($fieldName) { return $this->class->getTableName(); } public function load(array $criteria, $entity = null, $assoc = null, array $hints = [], $lockMode = null, $limit = null, array $orderBy = null) { $this->switchPersisterContext(null, $limit); $sql = $this->getSelectSQL($criteria, $assoc, $lockMode, $limit, null, $orderBy); [$params, $types] = $this->expandParameters($criteria); $stmt = $this->conn->executeQuery($sql, $params, $types); if ($entity !== null) { $hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH] = \true; $hints[\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH_ENTITY] = $entity; } $hydrator = $this->em->newHydrator($this->currentPersisterContext->selectJoinSql ? \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_OBJECT : \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_SIMPLEOBJECT); $entities = $hydrator->hydrateAll($stmt, $this->currentPersisterContext->rsm, $hints); return $entities ? $entities[0] : null; } public function loadById(array $identifier, $entity = null) { return $this->load($identifier, $entity); } public function loadOneToOneEntity(array $assoc, $sourceEntity, array $identifier = []) { if (($foundEntity = $this->em->getUnitOfWork()->tryGetById($identifier, $assoc['targetEntity'])) != \false) { return $foundEntity; } $targetClass = $this->em->getClassMetadata($assoc['targetEntity']); if ($assoc['isOwningSide']) { $isInverseSingleValued = $assoc['inversedBy'] && !$targetClass->isCollectionValuedAssociation($assoc['inversedBy']); $hints = []; if ($isInverseSingleValued) { $hints['fetched']["r"][$assoc['inversedBy']] = \true; } $targetEntity = $this->load($identifier, null, $assoc, $hints); if ($targetEntity !== null && $isInverseSingleValued) { $targetClass->reflFields[$assoc['inversedBy']]->setValue($targetEntity, $sourceEntity); } return $targetEntity; } $sourceClass = $this->em->getClassMetadata($assoc['sourceEntity']); $owningAssoc = $targetClass->getAssociationMapping($assoc['mappedBy']); $computedIdentifier = []; foreach ($owningAssoc['targetToSourceKeyColumns'] as $sourceKeyColumn => $targetKeyColumn) { if (!isset($sourceClass->fieldNames[$sourceKeyColumn])) { throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::joinColumnMustPointToMappedField($sourceClass->name, $sourceKeyColumn); } $computedIdentifier[$targetClass->getFieldForColumn($targetKeyColumn)] = $sourceClass->reflFields[$sourceClass->fieldNames[$sourceKeyColumn]]->getValue($sourceEntity); } $targetEntity = $this->load($computedIdentifier, null, $assoc); if ($targetEntity !== null) { $targetClass->setFieldValue($targetEntity, $assoc['mappedBy'], $sourceEntity); } return $targetEntity; } public function refresh(array $id, $entity, $lockMode = null) { $sql = $this->getSelectSQL($id, null, $lockMode); [$params, $types] = $this->expandParameters($id); $stmt = $this->conn->executeQuery($sql, $params, $types); $hydrator = $this->em->newHydrator(\MailPoetVendor\Doctrine\ORM\Query::HYDRATE_OBJECT); $hydrator->hydrateAll($stmt, $this->currentPersisterContext->rsm, [\MailPoetVendor\Doctrine\ORM\Query::HINT_REFRESH => \true]); } public function count($criteria = []) { $sql = $this->getCountSQL($criteria); [$params, $types] = $criteria instanceof \MailPoetVendor\Doctrine\Common\Collections\Criteria ? $this->expandCriteriaParameters($criteria) : $this->expandParameters($criteria); return (int) $this->conn->executeQuery($sql, $params, $types)->fetchColumn(); } public function loadCriteria(\MailPoetVendor\Doctrine\Common\Collections\Criteria $criteria) { $orderBy = $criteria->getOrderings(); $limit = $criteria->getMaxResults(); $offset = $criteria->getFirstResult(); $query = $this->getSelectSQL($criteria, null, null, $limit, $offset, $orderBy); [$params, $types] = $this->expandCriteriaParameters($criteria); $stmt = $this->conn->executeQuery($query, $params, $types); $hydrator = $this->em->newHydrator($this->currentPersisterContext->selectJoinSql ? \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_OBJECT : \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_SIMPLEOBJECT); return $hydrator->hydrateAll($stmt, $this->currentPersisterContext->rsm, [\MailPoetVendor\Doctrine\ORM\UnitOfWork::HINT_DEFEREAGERLOAD => \true]); } public function expandCriteriaParameters(\MailPoetVendor\Doctrine\Common\Collections\Criteria $criteria) { $expression = $criteria->getWhereExpression(); $sqlParams = []; $sqlTypes = []; if ($expression === null) { return [$sqlParams, $sqlTypes]; } $valueVisitor = new \MailPoetVendor\Doctrine\ORM\Persisters\SqlValueVisitor(); $valueVisitor->dispatch($expression); [$params, $types] = $valueVisitor->getParamsAndTypes(); foreach ($params as $param) { $sqlParams = \array_merge($sqlParams, $this->getValues($param)); } foreach ($types as $type) { [$field, $value] = $type; $sqlTypes = \array_merge($sqlTypes, $this->getTypes($field, $value, $this->class)); } return [$sqlParams, $sqlTypes]; } public function loadAll(array $criteria = [], array $orderBy = null, $limit = null, $offset = null) { $this->switchPersisterContext($offset, $limit); $sql = $this->getSelectSQL($criteria, null, null, $limit, $offset, $orderBy); [$params, $types] = $this->expandParameters($criteria); $stmt = $this->conn->executeQuery($sql, $params, $types); $hydrator = $this->em->newHydrator($this->currentPersisterContext->selectJoinSql ? \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_OBJECT : \MailPoetVendor\Doctrine\ORM\Query::HYDRATE_SIMPLEOBJECT); return $hydrator->hydrateAll($stmt, $this->currentPersisterContext->rsm, [\MailPoetVendor\Doctrine\ORM\UnitOfWork::HINT_DEFEREAGERLOAD => \true]); } public function getManyToManyCollection(array $assoc, $sourceEntity, $offset = null, $limit = null) { $this->switchPersisterContext($offset, $limit); $stmt = $this->getManyToManyStatement($assoc, $sourceEntity, $offset, $limit); return $this->loadArrayFromStatement($assoc, $stmt); } private function loadArrayFromStatement($assoc, $stmt) { $rsm = $this->currentPersisterContext->rsm; $hints = [\MailPoetVendor\Doctrine\ORM\UnitOfWork::HINT_DEFEREAGERLOAD => \true]; if (isset($assoc['indexBy'])) { $rsm = clone $this->currentPersisterContext->rsm; $rsm->addIndexBy('r', $assoc['indexBy']); } return $this->em->newHydrator(\MailPoetVendor\Doctrine\ORM\Query::HYDRATE_OBJECT)->hydrateAll($stmt, $rsm, $hints); } private function loadCollectionFromStatement($assoc, $stmt, $coll) { $rsm = $this->currentPersisterContext->rsm; $hints = [\MailPoetVendor\Doctrine\ORM\UnitOfWork::HINT_DEFEREAGERLOAD => \true, 'collection' => $coll]; if (isset($assoc['indexBy'])) { $rsm = clone $this->currentPersisterContext->rsm; $rsm->addIndexBy('r', $assoc['indexBy']); } return $this->em->newHydrator(\MailPoetVendor\Doctrine\ORM\Query::HYDRATE_OBJECT)->hydrateAll($stmt, $rsm, $hints); } public function loadManyToManyCollection(array $assoc, $sourceEntity, \MailPoetVendor\Doctrine\ORM\PersistentCollection $collection) { $stmt = $this->getManyToManyStatement($assoc, $sourceEntity); return $this->loadCollectionFromStatement($assoc, $stmt, $collection); } private function getManyToManyStatement(array $assoc, $sourceEntity, $offset = null, $limit = null) { $this->switchPersisterContext($offset, $limit); $sourceClass = $this->em->getClassMetadata($assoc['sourceEntity']); $class = $sourceClass; $association = $assoc; $criteria = []; $parameters = []; if (!$assoc['isOwningSide']) { $class = $this->em->getClassMetadata($assoc['targetEntity']); $association = $class->associationMappings[$assoc['mappedBy']]; } $joinColumns = $assoc['isOwningSide'] ? $association['joinTable']['joinColumns'] : $association['joinTable']['inverseJoinColumns']; $quotedJoinTable = $this->quoteStrategy->getJoinTableName($association, $class, $this->platform); foreach ($joinColumns as $joinColumn) { $sourceKeyColumn = $joinColumn['referencedColumnName']; $quotedKeyColumn = $this->quoteStrategy->getJoinColumnName($joinColumn, $class, $this->platform); switch (\true) { case $sourceClass->containsForeignIdentifier: $field = $sourceClass->getFieldForColumn($sourceKeyColumn); $value = $sourceClass->reflFields[$field]->getValue($sourceEntity); if (isset($sourceClass->associationMappings[$field])) { $value = $this->em->getUnitOfWork()->getEntityIdentifier($value); $value = $value[$this->em->getClassMetadata($sourceClass->associationMappings[$field]['targetEntity'])->identifier[0]]; } break; case isset($sourceClass->fieldNames[$sourceKeyColumn]): $field = $sourceClass->fieldNames[$sourceKeyColumn]; $value = $sourceClass->reflFields[$field]->getValue($sourceEntity); break; default: throw \MailPoetVendor\Doctrine\ORM\Mapping\MappingException::joinColumnMustPointToMappedField($sourceClass->name, $sourceKeyColumn); } $criteria[$quotedJoinTable . '.' . $quotedKeyColumn] = $value; $parameters[] = ['value' => $value, 'field' => $field, 'class' => $sourceClass]; } $sql = $this->getSelectSQL($criteria, $assoc, null, $limit, $offset); [$params, $types] = $this->expandToManyParameters($parameters); return $this->conn->executeQuery($sql, $params, $types); } public function getSelectSQL($criteria, $assoc = null, $lockMode = null, $limit = null, $offset = null, array $orderBy = null) { $this->switchPersisterContext($offset, $limit); $lockSql = ''; $joinSql = ''; $orderBySql = ''; if ($assoc != null && $assoc['type'] == \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::MANY_TO_MANY) { $joinSql = $this->getSelectManyToManyJoinSQL($assoc); } if (isset($assoc['orderBy'])) { $orderBy = $assoc['orderBy']; } if ($orderBy) { $orderBySql = $this->getOrderBySQL($orderBy, $this->getSQLTableAlias($this->class->name)); } $conditionSql = $criteria instanceof \MailPoetVendor\Doctrine\Common\Collections\Criteria ? $this->getSelectConditionCriteriaSQL($criteria) : $this->getSelectConditionSQL($criteria, $assoc); switch ($lockMode) { case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_READ: $lockSql = ' ' . $this->platform->getReadLockSQL(); break; case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_WRITE: $lockSql = ' ' . $this->platform->getWriteLockSQL(); break; } $columnList = $this->getSelectColumnsSQL(); $tableAlias = $this->getSQLTableAlias($this->class->name); $filterSql = $this->generateFilterConditionSQL($this->class, $tableAlias); $tableName = $this->quoteStrategy->getTableName($this->class, $this->platform); if ('' !== $filterSql) { $conditionSql = $conditionSql ? $conditionSql . ' AND ' . $filterSql : $filterSql; } $select = 'SELECT ' . $columnList; $from = ' FROM ' . $tableName . ' ' . $tableAlias; $join = $this->currentPersisterContext->selectJoinSql . $joinSql; $where = $conditionSql ? ' WHERE ' . $conditionSql : ''; $lock = $this->platform->appendLockHint($from, $lockMode); $query = $select . $lock . $join . $where . $orderBySql; return $this->platform->modifyLimitQuery($query, $limit, $offset) . $lockSql; } public function getCountSQL($criteria = []) { $tableName = $this->quoteStrategy->getTableName($this->class, $this->platform); $tableAlias = $this->getSQLTableAlias($this->class->name); $conditionSql = $criteria instanceof \MailPoetVendor\Doctrine\Common\Collections\Criteria ? $this->getSelectConditionCriteriaSQL($criteria) : $this->getSelectConditionSQL($criteria); $filterSql = $this->generateFilterConditionSQL($this->class, $tableAlias); if ('' !== $filterSql) { $conditionSql = $conditionSql ? $conditionSql . ' AND ' . $filterSql : $filterSql; } $sql = 'SELECT COUNT(*) ' . 'FROM ' . $tableName . ' ' . $tableAlias . (empty($conditionSql) ? '' : ' WHERE ' . $conditionSql); return $sql; } protected final function getOrderBySQL(array $orderBy, $baseTableAlias) : string { $orderByList = []; foreach ($orderBy as $fieldName => $orientation) { $orientation = \strtoupper(\trim($orientation)); if ($orientation != 'ASC' && $orientation != 'DESC') { throw \MailPoetVendor\Doctrine\ORM\ORMException::invalidOrientation($this->class->name, $fieldName); } if (isset($this->class->fieldMappings[$fieldName])) { $tableAlias = isset($this->class->fieldMappings[$fieldName]['inherited']) ? $this->getSQLTableAlias($this->class->fieldMappings[$fieldName]['inherited']) : $baseTableAlias; $columnName = $this->quoteStrategy->getColumnName($fieldName, $this->class, $this->platform); $orderByList[] = $tableAlias . '.' . $columnName . ' ' . $orientation; continue; } if (isset($this->class->associationMappings[$fieldName])) { if (!$this->class->associationMappings[$fieldName]['isOwningSide']) { throw \MailPoetVendor\Doctrine\ORM\ORMException::invalidFindByInverseAssociation($this->class->name, $fieldName); } $tableAlias = isset($this->class->associationMappings[$fieldName]['inherited']) ? $this->getSQLTableAlias($this->class->associationMappings[$fieldName]['inherited']) : $baseTableAlias; foreach ($this->class->associationMappings[$fieldName]['joinColumns'] as $joinColumn) { $columnName = $this->quoteStrategy->getJoinColumnName($joinColumn, $this->class, $this->platform); $orderByList[] = $tableAlias . '.' . $columnName . ' ' . $orientation; } continue; } throw \MailPoetVendor\Doctrine\ORM\ORMException::unrecognizedField($fieldName); } return ' ORDER BY ' . \implode(', ', $orderByList); } protected function getSelectColumnsSQL() { if ($this->currentPersisterContext->selectColumnListSql !== null) { return $this->currentPersisterContext->selectColumnListSql; } $columnList = []; $this->currentPersisterContext->rsm->addEntityResult($this->class->name, 'r'); foreach ($this->class->fieldNames as $field) { $columnList[] = $this->getSelectColumnSQL($field, $this->class); } $this->currentPersisterContext->selectJoinSql = ''; $eagerAliasCounter = 0; foreach ($this->class->associationMappings as $assocField => $assoc) { $assocColumnSQL = $this->getSelectColumnAssociationSQL($assocField, $assoc, $this->class); if ($assocColumnSQL) { $columnList[] = $assocColumnSQL; } $isAssocToOneInverseSide = $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE && !$assoc['isOwningSide']; $isAssocFromOneEager = $assoc['type'] !== \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::MANY_TO_MANY && $assoc['fetch'] === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::FETCH_EAGER; if (!($isAssocFromOneEager || $isAssocToOneInverseSide)) { continue; } if (($assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_MANY) > 0 && $this->currentPersisterContext->handlesLimits) { continue; } $eagerEntity = $this->em->getClassMetadata($assoc['targetEntity']); if ($eagerEntity->inheritanceType != \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::INHERITANCE_TYPE_NONE) { continue; } $assocAlias = 'e' . $eagerAliasCounter++; $this->currentPersisterContext->rsm->addJoinedEntityResult($assoc['targetEntity'], $assocAlias, 'r', $assocField); foreach ($eagerEntity->fieldNames as $field) { $columnList[] = $this->getSelectColumnSQL($field, $eagerEntity, $assocAlias); } foreach ($eagerEntity->associationMappings as $eagerAssocField => $eagerAssoc) { $eagerAssocColumnSQL = $this->getSelectColumnAssociationSQL($eagerAssocField, $eagerAssoc, $eagerEntity, $assocAlias); if ($eagerAssocColumnSQL) { $columnList[] = $eagerAssocColumnSQL; } } $association = $assoc; $joinCondition = []; if (isset($assoc['indexBy'])) { $this->currentPersisterContext->rsm->addIndexBy($assocAlias, $assoc['indexBy']); } if (!$assoc['isOwningSide']) { $eagerEntity = $this->em->getClassMetadata($assoc['targetEntity']); $association = $eagerEntity->getAssociationMapping($assoc['mappedBy']); } $joinTableAlias = $this->getSQLTableAlias($eagerEntity->name, $assocAlias); $joinTableName = $this->quoteStrategy->getTableName($eagerEntity, $this->platform); if ($assoc['isOwningSide']) { $tableAlias = $this->getSQLTableAlias($association['targetEntity'], $assocAlias); $this->currentPersisterContext->selectJoinSql .= ' ' . $this->getJoinSQLForJoinColumns($association['joinColumns']); foreach ($association['joinColumns'] as $joinColumn) { $sourceCol = $this->quoteStrategy->getJoinColumnName($joinColumn, $this->class, $this->platform); $targetCol = $this->quoteStrategy->getReferencedJoinColumnName($joinColumn, $this->class, $this->platform); $joinCondition[] = $this->getSQLTableAlias($association['sourceEntity']) . '.' . $sourceCol . ' = ' . $tableAlias . '.' . $targetCol; } if ($filterSql = $this->generateFilterConditionSQL($eagerEntity, $tableAlias)) { $joinCondition[] = $filterSql; } } else { $this->currentPersisterContext->selectJoinSql .= ' LEFT JOIN'; foreach ($association['joinColumns'] as $joinColumn) { $sourceCol = $this->quoteStrategy->getJoinColumnName($joinColumn, $this->class, $this->platform); $targetCol = $this->quoteStrategy->getReferencedJoinColumnName($joinColumn, $this->class, $this->platform); $joinCondition[] = $this->getSQLTableAlias($association['sourceEntity'], $assocAlias) . '.' . $sourceCol . ' = ' . $this->getSQLTableAlias($association['targetEntity']) . '.' . $targetCol; } } $this->currentPersisterContext->selectJoinSql .= ' ' . $joinTableName . ' ' . $joinTableAlias . ' ON '; $this->currentPersisterContext->selectJoinSql .= \implode(' AND ', $joinCondition); } $this->currentPersisterContext->selectColumnListSql = \implode(', ', $columnList); return $this->currentPersisterContext->selectColumnListSql; } protected function getSelectColumnAssociationSQL($field, $assoc, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class, $alias = 'r') { if (!($assoc['isOwningSide'] && $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE)) { return ''; } $columnList = []; $targetClass = $this->em->getClassMetadata($assoc['targetEntity']); $isIdentifier = isset($assoc['id']) && $assoc['id'] === \true; $sqlTableAlias = $this->getSQLTableAlias($class->name, $alias == 'r' ? '' : $alias); foreach ($assoc['joinColumns'] as $joinColumn) { $quotedColumn = $this->quoteStrategy->getJoinColumnName($joinColumn, $this->class, $this->platform); $resultColumnName = $this->getSQLColumnAlias($joinColumn['name']); $type = \MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper::getTypeOfColumn($joinColumn['referencedColumnName'], $targetClass, $this->em); $this->currentPersisterContext->rsm->addMetaResult($alias, $resultColumnName, $joinColumn['name'], $isIdentifier, $type); $columnList[] = \sprintf('%s.%s AS %s', $sqlTableAlias, $quotedColumn, $resultColumnName); } return \implode(', ', $columnList); } protected function getSelectManyToManyJoinSQL(array $manyToMany) { $conditions = []; $association = $manyToMany; $sourceTableAlias = $this->getSQLTableAlias($this->class->name); if (!$manyToMany['isOwningSide']) { $targetEntity = $this->em->getClassMetadata($manyToMany['targetEntity']); $association = $targetEntity->associationMappings[$manyToMany['mappedBy']]; } $joinTableName = $this->quoteStrategy->getJoinTableName($association, $this->class, $this->platform); $joinColumns = $manyToMany['isOwningSide'] ? $association['joinTable']['inverseJoinColumns'] : $association['joinTable']['joinColumns']; foreach ($joinColumns as $joinColumn) { $quotedSourceColumn = $this->quoteStrategy->getJoinColumnName($joinColumn, $this->class, $this->platform); $quotedTargetColumn = $this->quoteStrategy->getReferencedJoinColumnName($joinColumn, $this->class, $this->platform); $conditions[] = $sourceTableAlias . '.' . $quotedTargetColumn . ' = ' . $joinTableName . '.' . $quotedSourceColumn; } return ' INNER JOIN ' . $joinTableName . ' ON ' . \implode(' AND ', $conditions); } public function getInsertSQL() { if ($this->insertSql !== null) { return $this->insertSql; } $columns = $this->getInsertColumnList(); $tableName = $this->quoteStrategy->getTableName($this->class, $this->platform); if (empty($columns)) { $identityColumn = $this->quoteStrategy->getColumnName($this->class->identifier[0], $this->class, $this->platform); $this->insertSql = $this->platform->getEmptyIdentityInsertSQL($tableName, $identityColumn); return $this->insertSql; } $values = []; $columns = \array_unique($columns); foreach ($columns as $column) { $placeholder = '?'; if (isset($this->class->fieldNames[$column]) && isset($this->columnTypes[$this->class->fieldNames[$column]]) && isset($this->class->fieldMappings[$this->class->fieldNames[$column]]['requireSQLConversion'])) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($this->columnTypes[$this->class->fieldNames[$column]]); $placeholder = $type->convertToDatabaseValueSQL('?', $this->platform); } $values[] = $placeholder; } $columns = \implode(', ', $columns); $values = \implode(', ', $values); $this->insertSql = \sprintf('INSERT INTO %s (%s) VALUES (%s)', $tableName, $columns, $values); return $this->insertSql; } protected function getInsertColumnList() { $columns = []; foreach ($this->class->reflFields as $name => $field) { if ($this->class->isVersioned && $this->class->versionField == $name) { continue; } if (isset($this->class->embeddedClasses[$name])) { continue; } if (isset($this->class->associationMappings[$name])) { $assoc = $this->class->associationMappings[$name]; if ($assoc['isOwningSide'] && $assoc['type'] & \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::TO_ONE) { foreach ($assoc['joinColumns'] as $joinColumn) { $columns[] = $this->quoteStrategy->getJoinColumnName($joinColumn, $this->class, $this->platform); } } continue; } if (!$this->class->isIdGeneratorIdentity() || $this->class->identifier[0] != $name) { $columns[] = $this->quoteStrategy->getColumnName($name, $this->class, $this->platform); $this->columnTypes[$name] = $this->class->fieldMappings[$name]['type']; } } return $columns; } protected function getSelectColumnSQL($field, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class, $alias = 'r') { $root = $alias == 'r' ? '' : $alias; $tableAlias = $this->getSQLTableAlias($class->name, $root); $fieldMapping = $class->fieldMappings[$field]; $sql = \sprintf('%s.%s', $tableAlias, $this->quoteStrategy->getColumnName($field, $class, $this->platform)); $columnAlias = $this->getSQLColumnAlias($fieldMapping['columnName']); $this->currentPersisterContext->rsm->addFieldResult($alias, $columnAlias, $field); if (isset($fieldMapping['requireSQLConversion'])) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($fieldMapping['type']); $sql = $type->convertToPHPValueSQL($sql, $this->platform); } return $sql . ' AS ' . $columnAlias; } protected function getSQLTableAlias($className, $assocName = '') { if ($assocName) { $className .= '#' . $assocName; } if (isset($this->currentPersisterContext->sqlTableAliases[$className])) { return $this->currentPersisterContext->sqlTableAliases[$className]; } $tableAlias = 't' . $this->currentPersisterContext->sqlAliasCounter++; $this->currentPersisterContext->sqlTableAliases[$className] = $tableAlias; return $tableAlias; } public function lock(array $criteria, $lockMode) { $lockSql = ''; $conditionSql = $this->getSelectConditionSQL($criteria); switch ($lockMode) { case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_READ: $lockSql = $this->platform->getReadLockSQL(); break; case \MailPoetVendor\Doctrine\DBAL\LockMode::PESSIMISTIC_WRITE: $lockSql = $this->platform->getWriteLockSQL(); break; } $lock = $this->getLockTablesSql($lockMode); $where = ($conditionSql ? ' WHERE ' . $conditionSql : '') . ' '; $sql = 'SELECT 1 ' . $lock . $where . $lockSql; [$params, $types] = $this->expandParameters($criteria); $this->conn->executeQuery($sql, $params, $types); } protected function getLockTablesSql($lockMode) { return $this->platform->appendLockHint('FROM ' . $this->quoteStrategy->getTableName($this->class, $this->platform) . ' ' . $this->getSQLTableAlias($this->class->name), $lockMode); } protected function getSelectConditionCriteriaSQL(\MailPoetVendor\Doctrine\Common\Collections\Criteria $criteria) { $expression = $criteria->getWhereExpression(); if ($expression === null) { return ''; } $visitor = new \MailPoetVendor\Doctrine\ORM\Persisters\SqlExpressionVisitor($this, $this->class); return $visitor->dispatch($expression); } public function getSelectConditionStatementSQL($field, $value, $assoc = null, $comparison = null) { $selectedColumns = []; $columns = $this->getSelectConditionStatementColumnSQL($field, $assoc); if (\count($columns) > 1 && $comparison === \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::IN) { throw \MailPoetVendor\Doctrine\ORM\ORMException::cantUseInOperatorOnCompositeKeys(); } foreach ($columns as $column) { $placeholder = '?'; if (isset($this->class->fieldMappings[$field]['requireSQLConversion'])) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($this->class->fieldMappings[$field]['type']); $placeholder = $type->convertToDatabaseValueSQL($placeholder, $this->platform); } if (null !== $comparison) { if (($comparison === \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::EQ || $comparison === \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::IS) && null === $value) { $selectedColumns[] = $column . ' IS NULL'; continue; } if ($comparison === \MailPoetVendor\Doctrine\Common\Collections\Expr\Comparison::NEQ && null === $value) { $selectedColumns[] = $column . ' IS NOT NULL'; continue; } $selectedColumns[] = $column . ' ' . \sprintf(self::$comparisonMap[$comparison], $placeholder); continue; } if (\is_array($value)) { $in = \sprintf('%s IN (%s)', $column, $placeholder); if (\false !== \array_search(null, $value, \true)) { $selectedColumns[] = \sprintf('(%s OR %s IS NULL)', $in, $column); continue; } $selectedColumns[] = $in; continue; } if (null === $value) { $selectedColumns[] = \sprintf('%s IS NULL', $column); continue; } $selectedColumns[] = \sprintf('%s = %s', $column, $placeholder); } return \implode(' AND ', $selectedColumns); } private function getSelectConditionStatementColumnSQL($field, $assoc = null) { if (isset($this->class->fieldMappings[$field])) { if (isset($this->class->fieldMappings[$field]['inherited'])) { $className = $this->class->fieldMappings[$field]['inherited']; $class = $this->em->getClassMetadata($className); } else { $className = $this->class->name; $class = $this->class; } return [$this->getSQLTableAlias($className) . '.' . $this->quoteStrategy->getColumnName($field, $class, $this->platform)]; } if (isset($this->class->associationMappings[$field])) { $association = $this->class->associationMappings[$field]; $columns = []; $class = $this->class; if ($association['type'] === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::MANY_TO_MANY) { if (!$association['isOwningSide']) { $association = $assoc; } $joinTableName = $this->quoteStrategy->getJoinTableName($association, $class, $this->platform); $joinColumns = $assoc['isOwningSide'] ? $association['joinTable']['joinColumns'] : $association['joinTable']['inverseJoinColumns']; foreach ($joinColumns as $joinColumn) { $columns[] = $joinTableName . '.' . $this->quoteStrategy->getJoinColumnName($joinColumn, $class, $this->platform); } } else { if (!$association['isOwningSide']) { throw \MailPoetVendor\Doctrine\ORM\ORMException::invalidFindByInverseAssociation($this->class->name, $field); } $className = isset($association['inherited']) ? $association['inherited'] : $this->class->name; foreach ($association['joinColumns'] as $joinColumn) { $columns[] = $this->getSQLTableAlias($className) . '.' . $this->quoteStrategy->getJoinColumnName($joinColumn, $this->class, $this->platform); } } return $columns; } if ($assoc !== null && \strpos($field, " ") === \false && \strpos($field, "(") === \false) { return [$field]; } throw \MailPoetVendor\Doctrine\ORM\ORMException::unrecognizedField($field); } protected function getSelectConditionSQL(array $criteria, $assoc = null) { $conditions = []; foreach ($criteria as $field => $value) { $conditions[] = $this->getSelectConditionStatementSQL($field, $value, $assoc); } return \implode(' AND ', $conditions); } public function getOneToManyCollection(array $assoc, $sourceEntity, $offset = null, $limit = null) { $this->switchPersisterContext($offset, $limit); $stmt = $this->getOneToManyStatement($assoc, $sourceEntity, $offset, $limit); return $this->loadArrayFromStatement($assoc, $stmt); } public function loadOneToManyCollection(array $assoc, $sourceEntity, \MailPoetVendor\Doctrine\ORM\PersistentCollection $collection) { $stmt = $this->getOneToManyStatement($assoc, $sourceEntity); return $this->loadCollectionFromStatement($assoc, $stmt, $collection); } private function getOneToManyStatement(array $assoc, $sourceEntity, $offset = null, $limit = null) { $this->switchPersisterContext($offset, $limit); $criteria = []; $parameters = []; $owningAssoc = $this->class->associationMappings[$assoc['mappedBy']]; $sourceClass = $this->em->getClassMetadata($assoc['sourceEntity']); $tableAlias = $this->getSQLTableAlias($owningAssoc['inherited'] ?? $this->class->name); foreach ($owningAssoc['targetToSourceKeyColumns'] as $sourceKeyColumn => $targetKeyColumn) { if ($sourceClass->containsForeignIdentifier) { $field = $sourceClass->getFieldForColumn($sourceKeyColumn); $value = $sourceClass->reflFields[$field]->getValue($sourceEntity); if (isset($sourceClass->associationMappings[$field])) { $value = $this->em->getUnitOfWork()->getEntityIdentifier($value); $value = $value[$this->em->getClassMetadata($sourceClass->associationMappings[$field]['targetEntity'])->identifier[0]]; } $criteria[$tableAlias . "." . $targetKeyColumn] = $value; $parameters[] = ['value' => $value, 'field' => $field, 'class' => $sourceClass]; continue; } $field = $sourceClass->fieldNames[$sourceKeyColumn]; $value = $sourceClass->reflFields[$field]->getValue($sourceEntity); $criteria[$tableAlias . "." . $targetKeyColumn] = $value; $parameters[] = ['value' => $value, 'field' => $field, 'class' => $sourceClass]; } $sql = $this->getSelectSQL($criteria, $assoc, null, $limit, $offset); [$params, $types] = $this->expandToManyParameters($parameters); return $this->conn->executeQuery($sql, $params, $types); } public function expandParameters($criteria) { $params = []; $types = []; foreach ($criteria as $field => $value) { if ($value === null) { continue; } $types = \array_merge($types, $this->getTypes($field, $value, $this->class)); $params = \array_merge($params, $this->getValues($value)); } return [$params, $types]; } private function expandToManyParameters($criteria) { $params = []; $types = []; foreach ($criteria as $criterion) { if ($criterion['value'] === null) { continue; } $types = \array_merge($types, $this->getTypes($criterion['field'], $criterion['value'], $criterion['class'])); $params = \array_merge($params, $this->getValues($criterion['value'])); } return [$params, $types]; } private function getTypes($field, $value, \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class) { $types = []; switch (\true) { case isset($class->fieldMappings[$field]): $types = \array_merge($types, [$class->fieldMappings[$field]['type']]); break; case isset($class->associationMappings[$field]): $assoc = $class->associationMappings[$field]; $class = $this->em->getClassMetadata($assoc['targetEntity']); if (!$assoc['isOwningSide']) { $assoc = $class->associationMappings[$assoc['mappedBy']]; $class = $this->em->getClassMetadata($assoc['targetEntity']); } $columns = $assoc['type'] === \MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata::MANY_TO_MANY ? $assoc['relationToTargetKeyColumns'] : $assoc['sourceToTargetKeyColumns']; foreach ($columns as $column) { $types[] = \MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper::getTypeOfColumn($column, $class, $this->em); } break; default: $types[] = null; break; } if (\is_array($value)) { return \array_map(function ($type) { $type = \MailPoetVendor\Doctrine\DBAL\Types\Type::getType($type); return $type->getBindingType() + \MailPoetVendor\Doctrine\DBAL\Connection::ARRAY_PARAM_OFFSET; }, $types); } return $types; } private function getValues($value) { if (\is_array($value)) { $newValue = []; foreach ($value as $itemValue) { $newValue = \array_merge($newValue, $this->getValues($itemValue)); } return [$newValue]; } if (\is_object($value) && $this->em->getMetadataFactory()->hasMetadataFor(\MailPoetVendor\Doctrine\Common\Util\ClassUtils::getClass($value))) { $class = $this->em->getClassMetadata(\get_class($value)); if ($class->isIdentifierComposite) { $newValue = []; foreach ($class->getIdentifierValues($value) as $innerValue) { $newValue = \array_merge($newValue, $this->getValues($innerValue)); } return $newValue; } } return [$this->getIndividualValue($value)]; } private function getIndividualValue($value) { if (!\is_object($value) || !$this->em->getMetadataFactory()->hasMetadataFor(\MailPoetVendor\Doctrine\Common\Util\ClassUtils::getClass($value))) { return $value; } return $this->em->getUnitOfWork()->getSingleIdentifierValue($value); } public function exists($entity, \MailPoetVendor\Doctrine\Common\Collections\Criteria $extraConditions = null) { $criteria = $this->class->getIdentifierValues($entity); if (!$criteria) { return \false; } $alias = $this->getSQLTableAlias($this->class->name); $sql = 'SELECT 1 ' . $this->getLockTablesSql(null) . ' WHERE ' . $this->getSelectConditionSQL($criteria); [$params, $types] = $this->expandParameters($criteria); if (null !== $extraConditions) { $sql .= ' AND ' . $this->getSelectConditionCriteriaSQL($extraConditions); [$criteriaParams, $criteriaTypes] = $this->expandCriteriaParameters($extraConditions); $params = \array_merge($params, $criteriaParams); $types = \array_merge($types, $criteriaTypes); } if ($filterSql = $this->generateFilterConditionSQL($this->class, $alias)) { $sql .= ' AND ' . $filterSql; } return (bool) $this->conn->fetchColumn($sql, $params, 0, $types); } protected function getJoinSQLForJoinColumns($joinColumns) { foreach ($joinColumns as $joinColumn) { if (!isset($joinColumn['nullable']) || $joinColumn['nullable']) { return 'LEFT JOIN'; } } return 'INNER JOIN'; } public function getSQLColumnAlias($columnName) { return $this->quoteStrategy->getColumnAlias($columnName, $this->currentPersisterContext->sqlAliasCounter++, $this->platform); } protected function generateFilterConditionSQL(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $targetEntity, $targetTableAlias) { $filterClauses = []; foreach ($this->em->getFilters()->getEnabledFilters() as $filter) { if ('' !== ($filterExpr = $filter->addFilterConstraint($targetEntity, $targetTableAlias))) { $filterClauses[] = '(' . $filterExpr . ')'; } } $sql = \implode(' AND ', $filterClauses); return $sql ? "(" . $sql . ")" : ""; } protected function switchPersisterContext($offset, $limit) { if (null === $offset && null === $limit) { $this->currentPersisterContext = $this->noLimitsContext; return; } $this->currentPersisterContext = $this->limitsHandlingContext; } protected function getClassIdentifiersTypes(\MailPoetVendor\Doctrine\ORM\Mapping\ClassMetadata $class) : array { $entityManager = $this->em; return \array_map(static function ($fieldName) use($class, $entityManager) : string { $types = \MailPoetVendor\Doctrine\ORM\Utility\PersisterHelper::getTypeOfField($fieldName, $class, $entityManager); \assert(isset($types[0])); return $types[0]; }, $class->identifier); } } 