---
name: Bug report
about: Report a bug in this library
title: ''
labels: bug
assignees: ''

---

<!--
This form is for bug reports for this library only.
For general, language-agnostic questions and troubleshooting about the [Google Ads API](https://developers.google.com/google-ads/api/docs/start), please ask/look for answers [here](https://groups.google.com/g/adwords-api).

Please check existing issues to see if your bug has already been reported before creating a new issue. We encourage you to add any relevant information to the existing issue if one already exists.
-->

[DO NOT INCLUDE ANY PERSONAL OR SENSITIVE DATA - MAKE SURE TO REDACT CONTENT WHEN NECESSARY]

**What versions of the client library and Google Ads API are you using?**

<!--
- Client library (format: `vX.Y.Z`): the exhaustive list of all released versions of the client library is in the repository [releases' page](https://github.com/googleads/google-ads-php/releases).
- Google Ads API (format: `VX`): you can find the major version of the Google Ads API used by checking the namespace of your `GoogleAdsClient`, e.g., `Google\Ads\GoogleAds\Lib\V6\GoogleAdsClient`.
-->

**What environment are you using?**

<!--
The output generated by the script [`scripts/print_php_information.php`](https://github.com/googleads/google-ads-php/blob/master/scripts/print_php_information.php) can be used. Alternatively, you can provide with the following information:

- The PHP version: run `php -v`.
- The name and version of the operating system: run `php -r 'print php_uname();'`.
- Whether the C implementation of `protobuf` is used or not (see [details](https://developers.google.com/google-ads/api/docs/client-libs/php/protobuf)): run `php -r 'print phpversion("protobuf");'`.
- Whether the transport used is gRPC or REST (see [details](https://developers.google.com/google-ads/api/docs/client-libs/php/transport)): run `php -r 'print phpversion("grpc");'` and provide the value of the `transport` [client configuration](https://developers.google.com/google-ads/api/docs/client-libs/php/configuration) setting if set.
-->

**Actions taken**

<!--
Please provide a code snippet or steps to consistently reproduce the experienced behavior.
-->

**Expected result**

**Actual result**

<!--
Make sure you include information that can help us debug (full error message, exception listing, stack trace, [logs](https://developers.google.com/google-ads/api/docs/client-libs/php/logging)).
See [troubleshooting](https://developers.google.com/google-ads/api/docs/best-practices/troubleshooting) for how to diagnose problems better.
-->
 
**Anything else we should know about your project / environment**
